script_authors("mxGzz")

local sampev = require 'lib.samp.events'
local inicfg = require 'inicfg'

local defaults = {
	muted = {

	}
}

local ini = inicfg.load(defaults, 'pmuted.ini')

if not doesFileExist('moonloader/mutedtext.log') then
	local log = io.open("moonloader/mutedtext.log", "w")
	log:write('')
	log:close()
end

function main()
	if not isSampLoaded() or not isSampfuncsLoaded() then return end
	while not isSampAvailable() do wait(100) end
	sampRegisterChatCommand('p_mute', pmute)
	sampRegisterChatCommand('p_unmute', punmute)
	sampRegisterChatCommand('p_mutelist', pml)
	while true do
		for nick, time in pairs(ini.muted) do
			if time < os.time() then
				ini.muted[nick] = nil
				inicfg.save(ini, 'pmuted.ini')
				printStringNow(nick .. ' MUTE EXPIRED', 3000)
			end
		end
		wait(1000)
	end
end

function sampev.onServerMessage(color, text)
	for nick, time in pairs(ini.muted) do
		if text:find(nick) then
			local log = io.open("moonloader/mutedtext.log", "a+")
			log:write(os.date('[%H:%M:%S] ') .. text .. '\n')
			return false
		end
	end
end

function sampev.onPlayerChatBubble(id)
	for nick, time in pairs(ini.muted) do
	if sampIsPlayerConnected(id) and sampGetPlayerNickname(id) == nick then
	local log = io.open("moonloader/mutedtext.log", "a+")
	log:write(os.date('[%H:%M:%S] ') .. text .. '\n')
	return false
	end
	end
	end


function pml()
	local text = 'ID\t \t ()'
	local dialText = ''
	for nick, time in pairs(ini.muted) do
		--print(1)
		dialText = dialText .. '\n' .. sampGetPlayerIdByNickname(nick) .. '\t' .. nick .. '\t' .. tostring(tonumber(time) - os.time())
	end
	if dialText == '' then
		sampShowDialog(6767, '  ', '   ', 'OK', '', 0)
	else
		--printStringNow('ALIVe', 1000)
		sampShowDialog(6768, '  ', text .. dialText, 'OK', '', 5)
	end
end

function pmute(args)
	if not args:match('%d- %d*') then
		sampAddChatMessage('[P-MUTE]:  /p_mute [ID] []', 0x1E90FF)
		return
	end
	local id, time = args:match('(%d-) (%d*)')
	if not sampIsPlayerConnected(id) then
		sampAddChatMessage('[P-MUTE]:    ', 0x1E90FF)
		return
	end
	if ini.muted[sampGetPlayerNickname(id)] then
		sampAddChatMessage('[P-MUTE]:    ', 0x1E90FF)
		return
	end
	ini.muted[sampGetPlayerNickname(id)] = os.time() + time*60
	inicfg.save(ini, 'pmuted.ini')
	sampAddChatMessage(sampGetPlayerNickname(id) .. '   ' .. time .. ' ', 0x1E90FF)
end

function punmute(id)
	if not sampIsPlayerConnected(id) then
		sampAddChatMessage('[P-MUTE]:    ', 0x1E90FF)
		return
	end
	if not ini.muted[sampGetPlayerNickname(id)] then
		sampAddChatMessage('[P-MUTE]:   ', 0x1E90FF)
		return
	end
	ini.muted[sampGetPlayerNickname(id)] = nil
	inicfg.save(ini, 'pmuted.ini')
	sampAddChatMessage('[P-MUTE]:     ', 0x1E90FF)
end

function sampGetPlayerIdByNickname(nick)
	for i = 0, 999 do
		if sampIsPlayerConnected(i) and sampGetPlayerNickname(i) == nick then
			return i
		end
	end
	return 'N/A'
end